/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.data.listener;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.datapack.references.entity.PlayerReference;
import com.redpxnda.nucleus.datapack.references.item.ItemReference;
import com.redpxnda.nucleus.datapack.references.item.ItemStackReference;
import com.redpxnda.nucleus.datapack.references.storage.ComponentReference;
import com.redpxnda.nucleus.datapack.references.storage.ResourceLocationReference;
import com.redpxnda.respawnobelisks.data.listener.ObeliskInteraction;
import com.redpxnda.respawnobelisks.data.listener.ROBEReference;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.util.CoreUtils;
import com.redpxnda.respawnobelisks.util.QuadConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;

public class ObeliskCore {
    public static Map<ResourceLocation, ObeliskCore> CORES = new HashMap<ResourceLocation, ObeliskCore>();
    private static final ItemStack ANCIENT_CORE_STACK = ((Item)ModRegistries.OBELISK_CORE.get()).m_7968_();
    public static ObeliskCore ANCIENT_CORE;
    public final ResourceLocation item;
    public final TriFunction<@Nullable Player, ItemStack, RespawnObeliskBlockEntity, Double> chargeProvider;
    public final TriFunction<@Nullable Player, ItemStack, RespawnObeliskBlockEntity, Double> maxChargeProvider;
    public final QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> chargeSetter;
    public final QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> maxChargeSetter;
    public final List<ResourceLocation> interactions;
    @Nullable
    public final Component jeiGeneral;
    @Nullable
    public final Component jeiCharge;
    @Nullable
    public final Component jeiMaxCharge;
    @Nullable
    public final List<ItemStack> jeiChargeItems;
    public final boolean alwaysRequiresPlayer;
    private final Instance defaultInstance;

    public Instance getDefaultInstance() {
        return new Instance(this.defaultInstance.stack().m_41777_(), this);
    }

    public ObeliskCore(ItemStack instance, ResourceLocation item, TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Double> chargeHandler, TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Double> maxChargeHandler, QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> chargeSetter, QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> maxChargeSetter, List<ResourceLocation> interactions, @Nullable Component jeiGeneral, @Nullable Component jeiCharge, @Nullable Component jeiMaxCharge, @Nullable List<ItemStack> chargeItems, boolean alwaysRequiresPlayer) {
        this.item = item;
        this.chargeProvider = chargeHandler;
        this.maxChargeProvider = maxChargeHandler;
        this.chargeSetter = chargeSetter;
        this.maxChargeSetter = maxChargeSetter;
        this.interactions = interactions;
        this.jeiGeneral = jeiGeneral;
        this.jeiCharge = jeiCharge;
        this.jeiMaxCharge = jeiMaxCharge;
        this.jeiChargeItems = chargeItems;
        this.alwaysRequiresPlayer = alwaysRequiresPlayer;
        this.defaultInstance = new Instance(instance, this);
        CORES.put(item, this);
    }

    public ObeliskCore(ItemStack instance, ResourceLocation item, TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Double> chargeHandler, TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Double> maxChargeHandler, QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> chargeSetter, QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> maxChargeSetter, ObeliskInteraction interaction, @Nullable Component jeiGeneral, @Nullable Component jeiCharge, @Nullable Component jeiMaxCharge, @Nullable List<ItemStack> chargeItems, boolean alwaysRequiresPlayer) {
        this(instance, item, chargeHandler, maxChargeHandler, chargeSetter, maxChargeSetter, List.of(interaction.id), jeiGeneral, jeiCharge, jeiMaxCharge, chargeItems, alwaysRequiresPlayer);
    }

    public static ObeliskCore create(ItemStack instance, ResourceLocation item, TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Double> chargeHandler, TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Double> maxChargeHandler, QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> chargeSetter, QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> maxChargeSetter, List<ObeliskInteraction> interactions, @Nullable Component jeiGeneral, @Nullable Component jeiCharge, @Nullable Component jeiMaxCharge, @Nullable List<ItemStack> chargeItems, boolean alwaysRequiresPlayer) {
        return new ObeliskCore(instance, item, chargeHandler, maxChargeHandler, chargeSetter, maxChargeSetter, interactions.stream().map(i -> i.id).toList(), jeiGeneral, jeiCharge, jeiMaxCharge, chargeItems, alwaysRequiresPlayer);
    }

    static {
        CompoundTag tag = new CompoundTag();
        CoreUtils.setMaxCharge(tag, 100.0);
        CoreUtils.setCharge(tag, 100.0);
        ANCIENT_CORE_STACK.m_41751_(tag);
        ANCIENT_CORE = ObeliskCore.create(ANCIENT_CORE_STACK, ModRegistries.OBELISK_CORE_LOC, (TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Double>)((TriFunction)(player, stack, blockEntity) -> CoreUtils.getCharge(stack.m_41784_())), (TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Double>)((TriFunction)(player, stack, blockEntity) -> CoreUtils.getMaxCharge(stack.m_41784_())), (amnt, player, stack, blockEntity) -> CoreUtils.setCharge(stack.m_41784_(), amnt), (amnt, player, stack, blockEntity) -> CoreUtils.setMaxCharge(stack.m_41784_(), amnt), List.of(ObeliskInteraction.DEFAULT_CHARGING, ObeliskInteraction.INFINITE_CHARGE, ObeliskInteraction.TELEPORT, ObeliskInteraction.REVIVE, ObeliskInteraction.PROTECT, ObeliskInteraction.SAVE_INV), (Component)Component.m_237113_((String)"TEST"), (Component)Component.m_237113_((String)"give charge by TESTInG"), (Component)Component.m_237113_((String)"give max charge by TESTInG"), null, false);
    }

    public record Instance(ItemStack stack, ObeliskCore core) {
        public static Instance EMPTY = new Instance(ItemStack.f_41583_, null);
        public static Codec<Instance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.f_41582_.optionalFieldOf("stack").forGetter(i -> i.stack == null || i.stack == ItemStack.f_41583_ ? Optional.empty() : Optional.of(i.stack)), (App)ResourceLocation.f_135803_.optionalFieldOf("core").forGetter(i -> i.core == null ? Optional.empty() : Optional.of(i.core.item))).apply((Applicative)inst, (stack, core) -> core.isEmpty() || stack.isEmpty() ? EMPTY : new Instance((ItemStack)stack.get(), CORES.get(core.get()))));

        public boolean isEmpty() {
            return this == EMPTY || this.core == null || this.stack == null || this.stack == ItemStack.f_41583_;
        }
    }

    public static class Builder {
        public ResourceLocation item;
        public TriFunction<@Nullable Player, ItemStack, RespawnObeliskBlockEntity, Double> chargeProvider;
        public TriFunction<@Nullable Player, ItemStack, RespawnObeliskBlockEntity, Double> maxChargeProvider;
        public QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> chargeConsumer;
        public QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> maxChargeConsumer;
        public List<ResourceLocation> interactions = new ArrayList<ResourceLocation>();
        @Nullable
        public Component jeiGeneral = null;
        @Nullable
        public Component jeiCharge = null;
        @Nullable
        public Component jeiMaxCharge = null;
        @Nullable
        public List<ItemStack> jeiChargeItems = null;
        public boolean alwaysRequiresPlayer = false;
        public ItemStack stack = null;

        public static Builder create() {
            return new Builder();
        }

        public Builder withItem(ResourceLocation location) {
            this.item = location;
            return this;
        }

        public Builder withItem(String str) {
            this.item = new ResourceLocation(str);
            return this;
        }

        public Builder withItem(ResourceLocationReference ref) {
            this.item = (ResourceLocation)ref.instance;
            return this;
        }

        public Builder withItem(ItemReference<?> item) {
            this.item = Registry.f_122827_.m_7981_((Object)((Item)item.instance));
            return this;
        }

        public Builder chargeGetter(TriFunction<@Nullable Player, ItemStack, RespawnObeliskBlockEntity, Double> handler) {
            this.chargeProvider = handler;
            return this;
        }

        public Builder chargeGetter(LuaFunction handler) {
            this.chargeProvider = (player, stack, be) -> handler.call(CoerceJavaToLua.coerce((Object)new PlayerReference(player)), CoerceJavaToLua.coerce((Object)new ItemStackReference(stack)), CoerceJavaToLua.coerce((Object)((Object)new ROBEReference((RespawnObeliskBlockEntity)((Object)be))))).todouble();
            return this;
        }

        public Builder maxChargeGetter(TriFunction<@Nullable Player, ItemStack, RespawnObeliskBlockEntity, Double> handler) {
            this.maxChargeProvider = handler;
            return this;
        }

        public Builder maxChargeGetter(LuaFunction handler) {
            this.maxChargeProvider = (player, stack, be) -> handler.call(CoerceJavaToLua.coerce((Object)new PlayerReference(player)), CoerceJavaToLua.coerce((Object)new ItemStackReference(stack)), CoerceJavaToLua.coerce((Object)((Object)new ROBEReference((RespawnObeliskBlockEntity)((Object)be))))).todouble();
            return this;
        }

        public Builder chargeSetter(QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> handler) {
            this.chargeConsumer = handler;
            return this;
        }

        public Builder chargeSetter(LuaFunction handler) {
            this.chargeConsumer = (amnt, player, stack, be) -> handler.invoke(new LuaValue[]{LuaValue.valueOf((double)amnt), CoerceJavaToLua.coerce((Object)new PlayerReference(player)), CoerceJavaToLua.coerce((Object)new ItemStackReference(stack)), CoerceJavaToLua.coerce((Object)((Object)new ROBEReference((RespawnObeliskBlockEntity)((Object)be))))});
            return this;
        }

        public Builder maxChargeSetter(QuadConsumer<Double, @Nullable Player, ItemStack, RespawnObeliskBlockEntity> handler) {
            this.maxChargeConsumer = handler;
            return this;
        }

        public Builder maxChargeSetter(LuaFunction handler) {
            this.maxChargeConsumer = (amnt, player, stack, be) -> handler.invoke(new LuaValue[]{LuaValue.valueOf((double)amnt), CoerceJavaToLua.coerce((Object)new PlayerReference(player)), CoerceJavaToLua.coerce((Object)new ItemStackReference(stack)), CoerceJavaToLua.coerce((Object)((Object)new ROBEReference((RespawnObeliskBlockEntity)((Object)be))))});
            return this;
        }

        public Builder clearInteractions() {
            this.interactions.clear();
            return this;
        }

        public Builder withInteraction(ObeliskInteraction interaction) {
            this.interactions.add(interaction.id);
            return this;
        }

        public Builder withInteraction(ResourceLocationReference interaction) {
            this.interactions.add((ResourceLocation)interaction.instance);
            return this;
        }

        public Builder withInteraction(String interaction) {
            this.interactions.add(new ResourceLocation(interaction));
            return this;
        }

        public Builder jeiGeneralText(Component component) {
            this.jeiGeneral = component;
            return this;
        }

        public Builder jeiGeneralText(ComponentReference<?> component) {
            this.jeiGeneral = (Component)component.instance;
            return this;
        }

        public Builder jeiGeneralText(String str) {
            this.jeiGeneral = Component.m_237113_((String)str);
            return this;
        }

        public Builder jeiChargeText(Component component) {
            this.jeiCharge = component;
            return this;
        }

        public Builder jeiChargeText(ComponentReference<?> component) {
            this.jeiCharge = (Component)component.instance;
            return this;
        }

        public Builder jeiChargeText(String str) {
            this.jeiCharge = Component.m_237113_((String)str);
            return this;
        }

        public Builder jeiMaxChargeText(Component component) {
            this.jeiMaxCharge = component;
            return this;
        }

        public Builder jeiMaxChargeText(ComponentReference<?> component) {
            this.jeiMaxCharge = (Component)component.instance;
            return this;
        }

        public Builder jeiMaxChargeText(String str) {
            this.jeiMaxCharge = Component.m_237113_((String)str);
            return this;
        }

        public Builder withChargeItem(Item item) {
            if (this.jeiChargeItems == null) {
                this.jeiChargeItems = new ArrayList<ItemStack>();
            }
            this.jeiChargeItems.add(item.m_7968_());
            return this;
        }

        public Builder withChargeItem(ItemReference<?> item) {
            if (this.jeiChargeItems == null) {
                this.jeiChargeItems = new ArrayList<ItemStack>();
            }
            this.jeiChargeItems.add(((Item)item.instance).m_7968_());
            return this;
        }

        public Builder withChargeItem(ItemStack item) {
            if (this.jeiChargeItems == null) {
                this.jeiChargeItems = new ArrayList<ItemStack>();
            }
            this.jeiChargeItems.add(item);
            return this;
        }

        public Builder withChargeItem(ItemStackReference item) {
            if (this.jeiChargeItems == null) {
                this.jeiChargeItems = new ArrayList<ItemStack>();
            }
            this.jeiChargeItems.add((ItemStack)item.instance);
            return this;
        }

        public Builder alwaysRequiresPlayer(boolean bl) {
            this.alwaysRequiresPlayer = bl;
            return this;
        }

        public Builder setCoreItem(String str) {
            this.item = new ResourceLocation(str);
            return this;
        }

        public Builder defaultInstanceHandler(LuaFunction function) {
            this.stack = (ItemStack)CoerceLuaToJava.coerce((LuaValue)function.call(CoerceJavaToLua.coerce((Object)new ItemStackReference(Registry.f_122827_.m_6612_(this.item).orElse(Items.f_41852_).m_7968_()))), ItemStack.class);
            return this;
        }

        public ObeliskCore build() {
            if (this.stack == null) {
                this.stack = Registry.f_122827_.m_6612_(this.item).orElse(Items.f_41852_).m_7968_();
            }
            return new ObeliskCore(this.stack, this.item, this.chargeProvider, this.maxChargeProvider, this.chargeConsumer, this.maxChargeConsumer, this.interactions, this.jeiGeneral, this.jeiCharge, this.jeiMaxCharge, this.jeiChargeItems, this.alwaysRequiresPlayer);
        }

        private Builder() {
        }
    }
}

